# AI Face Swap Web App

A web application that uses the MagicHour AI API to perform face swapping between two images.

## Features

- **Web Interface**: Easy-to-use web interface for uploading images
- **Drag & Drop**: Support for drag and drop file uploads
- **Real-time Preview**: Preview uploaded images before processing
- **Face Swap**: Swap faces between two photos using MagicHour AI
- **Download Results**: Download the generated face swap images
- **Responsive Design**: Works on desktop and mobile devices

## Setup

### Prerequisites

- Python 3.7+
- MagicHour AI API key (get it from [MagicHour Developer Hub](https://magichour.ai/developer?tab=api-keys))

### Installation

1. Clone or download this project
2. Install Python dependencies:

   ```bash
   pip install -r requirements.txt
   ```

3. Set your MagicHour API key as an environment variable:

   ```bash
   # Windows (PowerShell)
   $env:MAGICHOUR_API_KEY = "your_api_key_here"

   # Windows (Command Prompt)
   set MAGICHOUR_API_KEY=your_api_key_here

   # Linux/Mac
   export MAGICHOUR_API_KEY=your_api_key_here
   ```

4. Run the application:

   ```bash
   python app.py
   ```

5. Open your web browser and go to `http://localhost:5000`

### Environment Variables

- `MAGICHOUR_API_KEY`: Your MagicHour AI API key (required)

## Usage

1. **Upload Source Image**: Click on the first upload area or drag and drop the image containing the face you want to copy
2. **Upload Target Image**: Click on the second upload area or drag and drop the image where you want to replace the face
3. **Process**: Click the "Create Face Swap" button to start the AI processing
4. **Download**: Once processing is complete, download your result image

## File Structure

```
AIfaceswap/
├── app.py                 # Main Flask application
├── requirements.txt       # Python dependencies
├── README.md             # This file
├── templates/
│   └── index.html        # Web interface template
├── uploads/              # Temporary upload directory
└── results/              # Results directory
```

## API Integration

This app integrates with the MagicHour AI Face Swap API:

- **Endpoint**: `POST https://api.magichour.ai/v1/face-swap-photo`
- **Authentication**: Bearer token
- **Cost**: 5 credits per face swap
- **Supported formats**: PNG, JPG, JPEG, GIF
- **Max file size**: 16MB

## Technical Details

- **Backend**: Flask (Python web framework)
- **Frontend**: Bootstrap 5, HTML5, JavaScript
- **Image Processing**: PIL (Python Imaging Library)
- **File Handling**: Secure file uploads with validation
- **API Integration**: RESTful API calls to MagicHour

## Security Features

- Secure filename handling
- File type validation
- File size limits
- Unique file naming to prevent conflicts

## Troubleshooting

1. **API Key Issues**: Make sure your `MAGICHOUR_API_KEY` environment variable is set correctly
2. **File Upload Issues**: Ensure images are under 16MB and in supported formats
3. **Processing Timeout**: Large images may take longer to process; wait for completion
4. **Credits**: Each face swap costs 5 credits on your MagicHour account

## License

This project is for educational and personal use. Please check MagicHour AI's terms of service for API usage restrictions.
